VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmInfo 
   Caption         =   "  Save Mail - Information"
   ClientHeight    =   9408
   ClientLeft      =   48
   ClientTop       =   348
   ClientWidth     =   10512
   OleObjectBlob   =   "frmInfo.frx":0000
   StartUpPosition =   1  'CenterOwner
End
Attribute VB_Name = "frmInfo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Type BROWSEINFO
  hOwner As Long
  pidlRoot As Long
  pszDisplayName As String
  lpszTitle As String
  ulFlags As Long
  lpfn As Long
  lParam As Long
  iImage As Long
End Type

Private Type FolderRecord
    Path As String
    EntryID As String
    StoreID As String
    Name As String
End Type

Private Declare Function SHGetPathFromIDList Lib "shell32.dll" Alias _
            "SHGetPathFromIDListA" (ByVal pidl As Long, _
            ByVal pszPath As String) As Long
            
Private Declare Function SHBrowseForFolder Lib "shell32.dll" Alias _
            "SHBrowseForFolderA" (lpBrowseInfo As BROWSEINFO) _
            As Long
            
Private Const BIF_RETURNONLYFSDIRS = &H1
Private GlobalStop As Boolean
Private FolderList() As FolderRecord
Private ListCount As Integer
Private ExportStarted As Boolean
Private frm As frmInfo
Private GlobalCount As Integer
Private StartDate As Date
Private EndDate As Date
Private ProcessPersonalFolders As Boolean

Private Property Get RootDir() As String
  RootDir = txtOutputPath.Text
End Property

Private Function AddBackslash(Name As String) As String
  Dim i As Integer
  i = Len(Name)
  If (i > 0) And Right(Name, 1) <> "\" Then
    Name = Name + "\"
  End If
  AddBackslash = Name
End Function

Private Sub btnBrowse_Click()

  Dim FileName As String
  FileName = BrowseFolder("Select a Folder for the messages")
  txtOutputPath.Text = AddBackslash(FileName)
End Sub

Private Sub btnStop_Click()
   If Not ExportStarted Then
   
    If RootDir = "" Then
      MsgBox "Please specify a ""Save to"" directory."
      Exit Sub
    End If
    
    txtError.Text = ""
    GlobalStop = False
    btnStop.Caption = "Stop"
    StartDate = txtStartDate.Text
    EndDate = txtEndDate.Text
    ProcessPersonalFolders = ckbProcessPersonalFolders.Value
    ExportStarted = True
    ExecuteExport
    ExportStarted = False
    btnStop.Caption = "Start"
    
  Else
    btnStop.Caption = "Start"
    ExportStarted = False
    GlobalStop = True
  End If
End Sub

Public Sub All_Export()
  Set frm = New frmInfo
  frm.Show
End Sub

Private Sub ExecuteExport()
  If Not ExportStarted Then
    Call MsgBox("Use the StartExport macro", vbApplicationModal)
    Exit Sub
  End If
    
  lngItemCountInCache = 0
  ListCount = 0
  GlobalCount = 0

  ' Get a list of all of the folders.
  Dim msgFolder As MAPIFolder
  Dim Ctr As Integer
  Dim FolderR As String
  Ctr = 0
  ListCount = 0
  For Each msgFolder In Application.GetNamespace("MAPI").Folders
  If msgFolder.Name <> "Public Folders" Then
    FolderR = LCase(Left(msgFolder.Name, 7))
    If ProcessPersonalFolders Or (FolderR = "mailbox") Then
      Call GetFolderInfo(msgFolder, msgFolder.Name)
    End If
  End If
  Next msgFolder
    
  On Error GoTo Oops
  
  Set msgFolder = Nothing
  For i = 0 To ListCount
    Call ExportMailFiles(FolderList(i))
    DoEvents
    If GlobalStop Then Exit For
  Next i
    
Oops:
  If Err <> 0 Then
    frm.txtError.Text = frm.txtError.Text & vbCrLf & "Error: " & Error
    Resume Next
  End If
  On Error GoTo 0
  If GlobalStop Then
    txtError.Text = txtError.Text & vbCrLf & vbCrLf & "Stopped!"
  Else
    txtError.Text = txtError.Text & vbCrLf & vbCrLf & "Finished!"
  End If
End Sub

Private Sub GetFolderInfo(msgFolder As MAPIFolder, SuperFolderName As String)
    Dim recOfFile As FolderRecord
    Dim curFolder As MAPIFolder
    On Error GoTo Skipit

    With recOfFile
        .Path = SuperFolderName
        .EntryID = msgFolder.EntryID
        .StoreID = msgFolder.StoreID
        .Name = msgFolder.Name
        ListCount = ListCount + 1
    End With
    
    ReDim Preserve FolderList(ListCount)
    FolderList(UBound(FolderList)) = recOfFile
    
    If msgFolder.Folders.Count > 0 Then
        For Each curFolder In msgFolder.Folders
            If ProcessPersonalFolders Or (curFolder = "Inbox") Then
              Call GetFolderInfo(curFolder, SuperFolderName + "\" + curFolder.Name)
            End If
        Next curFolder
    End If
Skipit:
   On Error GoTo 0
End Sub

Private Function FilterFileName(ByVal Line As String) As String
  Dim BadChars(5) As String
  BadChars(0) = ":"
  BadChars(1) = "\"
  BadChars(2) = "/"
  BadChars(3) = "*"
  BadChars(4) = "?"
  BadChars(5) = "|"
  
  Dim p As Integer
  Dim q As Integer
  Dim i As Integer
  
  For i = LBound(BadChars) To UBound(BadChars)
    p = InStr(Line, BadChars(i))
    Do While (p > 0)
      q = Len(Line)
      Line = Left(Line, p - 1) & Right(Line, q - p)
      p = InStr(Line, BadChars(i))
    Loop
  Next i
  
  p = InStr(Line, """")
  Do While (p > 0)
    q = Len(Line)
    Line = Left(Line, p - 1) & "'" & Right(Line, q - p)
    p = InStr(Line, """")
  Loop
  
  i = 0
  Do While (i < Len(Line))
    i = i + 1
    If Asc(Mid(Line, i, 1)) < 20 Then
      If Asc(Mid(Line, i, 1)) = 13 Then
        Line = Left(Line, i - 1)
      Else
        Line = Left(Line, i - 1) & Right(Line, Len(Line) - i - 1)
      End If
    End If
  Loop
  
  FilterFileName = Line
End Function

Private Function FileDirectory(Directory As String) As String
  Dim SubDirs() As String
  Dim tempdir As String
  Dim i As Integer
  Dim j As Integer
  Dim p As Integer
  Dim q As Integer
  
  Directory = AddBackslash(Directory)
  i = 1
  j = 0
  q = 0
  p = InStr(q + 1, Directory, "\")
  Do While p > 0
    ReDim Preserve SubDirs(j)
    SubDirs(j) = Mid(Directory, q + 1, p - q - 1)
    If (j <> 0) Or (InStr(SubDirs(j), ":") <= 0) Then
      SubDirs(j) = FilterFileName(SubDirs(j))
    End If
    j = j + 1
    q = p
    p = InStr(q + 1, Directory, "\")
  Loop
  On Error Resume Next
  For i = LBound(SubDirs) To UBound(SubDirs)
    If InStr(SubDirs(i), ":") <= 0 Then
      tempdir = ""
      For j = 0 To i
        If j <> 0 Then
          tempdir = tempdir + "\" + SubDirs(j)
        Else
          tempdir = SubDirs(j)
        End If
      Next j
      MkDir (tempdir)
    End If
  Next i
  On Error GoTo 0
  Directory = ""
  For i = LBound(SubDirs) To UBound(SubDirs)
    Directory = Directory + SubDirs(i) + "\"
  Next i
  FileDirectory = Directory
End Function

Private Sub CheckFileExists(ByVal Path As String, ByRef FileName As String, ByVal Ext As String)
  Dim FN As String
  Dim FName As String
  Dim L As Integer
  Dim K As Integer
  
  FName = Path & FileName & Ext
  If Len(FName) > 255 Then
    FName = Left(FName, 255)
  End If
  FN = Dir(FName)
  If FN <> "" Then
    Dim Ctr As Integer
    Dim NFN As String
    Ctr = 1
    Do
      NFN = FileName & "(" & CStr(Ctr) & ")"
      If Len(Path & NFN & Ext) > 255 Then
        K = Len(Path & NFN & Ext) - 255
        L = Len(FileName)
        NFN = Left(FileName, L - K) & "(" & CStr(Ctr) & ")"
      End If
      FN = Dir(Path & NFN & Ext)
      Ctr = Ctr + 1
    Loop Until FN = ""
    FileName = NFN
  End If
End Sub

Private Sub ExportMailFiles(Folder As FolderRecord)
    Dim currFolder As MAPIFolder
    Dim LeadFolder As String
    Dim Ext As String
    Dim myItem As Object
    'Dim myAppointmentItem As AppointmentItem
    'Dim myMeetingItem As MeetingItem
    'Dim myContactItem As ContactItem
    'Dim myNoteItem As NoteItem
    'Dim myTaskItem As TaskItem
    Dim AvailActions As Outlook.Action
    Dim MailItem As Outlook.MailItem
    Dim FileName As String
    Dim Directory As String
    Dim Name As String
    Dim j As Integer
    Dim K As Integer
    
    Ext = ".msg"
    'If frm Is Nothing Then
    '  MsgBox "You must start using the ""StartExport"" macro."
    '  GlobalStop = True
    '  Exit Sub
    'End If
    LeaderFolder = AddBackslash(RootDir)
    j = 0
    If Folder.Name <> "" Then
      Set currFolder = Application.GetNamespace("MAPI").GetFolderFromID(Folder.EntryID, Folder.StoreID)
      If (currFolder <> "Sync Issues") And (currFolder <> "Sync Issues") Then
        For Each myItem In currFolder.Items
        Dim tDate As Date
        If InStr(1, myItem.MessageClass, "SMIME", vbTextCompare) = 0 Then
          j = j + 1
          Select Case myItem.Class
            Case Is = olMail
              On Error GoTo Oops
              Set MailItem = myItem
              tDate = myItem.SentOn
              If (tDate >= StartDate) And (tDate <= EndDate) Then
                FileName = FilterFileName(MailItem.Subject)
                Directory = FileDirectory(LeaderFolder & Folder.Path)
                Call CheckFileExists(Directory, FileName, Ext)
                txtCurFile.Text = FileName & Ext
                txtCurDir.Text = Directory
                DoEvents
                Dim FileName2 As String
                FileName2 = Directory & FileName & Ext
                If Len(FileName2) > 255 Then
                  FileName2 = Left(FileName2, 255)
                End If
                Call MailItem.SaveAs(FileName2, olMSG)
                Dim DblValue As Double
                DblValue = tDate
                ' set the date of the file to match the date of the mail
                Call SetFileDateTime(FileName2, DblValue, FileDateToProcess.FileDateCreate)
                Call SetFileDateTime(FileName2, DblValue, FileDateToProcess.FileDateLastModified)
                Call SetFileDateTime(FileName2, DblValue, FileDateToProcess.FileDateLastAccess)
                
                GlobalCount = GlobalCount + 1
                lblCount = "Count: " + CStr(GlobalCount)
              End If
Oops:
              If Err <> 0 Then
                Dim tStrErr As String
                tStrErr = Error
                txtError.Text = txtError.Text & vbCrLf & vbCrLf & "Not saved: " & FileName
                txtError.Text = txtError.Text & vbCrLf & "from: " & Folder.Path
                If Left(tStrErr, 51) = "There is not enough free memory to run this program" Then
                  txtError.Text = txtError.Text & vbCrLf & "The message is too large."
                Else
                  txtError.Text = txtError.Text & vbCrLf & "Stated Error: " & tStrErr
                End If
                DoEvents
                Resume Oops
              End If
              On Error GoTo 0
              DoEvents
              
            Case Is = olContact, olNote, olTask, olAppointment, olMeetingRequest, olMeetingCancellation, _
                      olmeetingresponsemegative, olMeetingResponsePositive, olMeetingResponseTentative
            Case Else
              txtError.Text = txtError.Text & vbCrLf & "Not saved: " & TypeName(myItem) & "," & myItem.Subject
          End Select
          If GlobalStop Then Exit Sub
        End If
        Next myItem
      End If
    End If
End Sub


'************** Code Start **************
'Some of this code was originally written by Terry Kreft.
'It is not to be altered or distributed,
'except as part of an application.
'You are free to use it in any application,
'provided the copyright notice is left unchanged.
'
'Code courtesy of
'Terry Kreft

Private Function BrowseFolder(szDialogTitle As String) As String
  Dim X As Long, bi As BROWSEINFO, dwIList As Long
  Dim szPath As String, wPos As Integer
  
    With bi
        .hOwner = hWndAccessApp
        .lpszTitle = szDialogTitle
        .ulFlags = BIF_RETURNONLYFSDIRS
    End With
    
    dwIList = SHBrowseForFolder(bi)
    szPath = Space$(512)
    X = SHGetPathFromIDList(ByVal dwIList, ByVal szPath)
    
    If X Then
        wPos = InStr(szPath, Chr(0))
        BrowseFolder = Left$(szPath, wPos - 1)
    Else
        BrowseFolder = vbNullString
    End If
End Function

'*********** Code End *****************

Private Sub UserForm_Activate()
  txtEndDate.Text = Format(Now, "dd-MMM-yyyy")
End Sub


